(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11562,        326]*)
(*NotebookOutlinePosition[     12330,        353]*)
(*  CellTagsIndexPosition[     12286,        349]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Subsection"],

Cell[TextData[{
  StyleBox[
  "En este ejercicio no debes hacer c\[AAcute]lculos simb\[OAcute]licos. "],
  StyleBox["Todos",
    FontSlant->"Italic"],
  StyleBox[
  " los resultados deben ser valores aproximados.\na) Crea una lista, que \
llamar\[AAcute]s \"lista1\", que empiece en 0 y termine en 1 con incrementos \
de "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`1\/200\)]]],
  StyleBox[
  ".\nb) Transforma lista1 en otra lista, que llamar\[AAcute]s \"lista2\", en \
la que cada elemento x\[Element]lista1 se ha reemplazado por "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`1\/\(x\^3 + 1\)\)]]],
  StyleBox[
  ".\nc) Forma una lista, que llamar\[AAcute]s \"lista3\", de pares de la \
forma {x,y} donde x\[Element]lista1, y\[Element]lista2 son elementos que \
ocupan el mismo lugar en sus respectivas listas.\nd) Define la \
funci\[OAcute]n (x,y) \[RightTeeArrow] "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(x - y\)\/\(1 + x\^2 + y\^2\)\)]]],
  StyleBox[
  " y la eval\[UAcute]as en los elementos de lista3 y a la lista resultante \
la llamas \"lista4\".\ne) Selecciona en lista4 los elementos mayores que "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(-1\)\/7\)]]],
  StyleBox[" y menores que "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`1\/7\)]]],
  StyleBox[
  ".\nf) Suma los cuadrados de los elementos de la lista obtenida en el \
apartado anterior."]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsection"],

Cell[TextData[StyleBox["a)",
  FontWeight->"Bold"]], "Text"],

Cell[BoxData[
    \(lista1 = Range[0. , 1. , 1/200]\)], "Input"],

Cell["Tambi\[EAcute]n puede hacerse como sigue.", "Text"],

Cell[BoxData[
    \(\(lista1 == Table[k, {k, 0. , 1. , 1/200}]\  (*\ 
      compruebo\ que\ las\ listas\ son\ iguales\ *) \)\)], "Input"],

Cell["\<\
Algunos ni siquieran hacen esto o lo hacen mal. El principal fallo en este \
apartado es generar una lista con valores exactos. No ser\[AAcute] porque no \
insist\[IAcute] en que no quer\[IAcute]a ver ni una sola fracci\[OAcute]n \
entre los resultados. Naturalmente, para obtener una lista con valores \
aproximados, basta con dar los datos inicial y final de forma aproximada. No \
s\[EAcute] c\[OAcute]mo decir las cosas. Algunos parecen que o son sordos o \
no quieren o\[IAcute]r. Algunos hacen lo que sigue.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Range[0, 1. , 1. /200]; 
    \) (*\ peque\[NTilde]o\ error\ porque\ el\ primer\ valor\ de\ la\ lista, 
      \ 0\ es\ exacto\ *) \)\)], "Input"],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " Este apartado puede hacerse de varias formas: trabajando directamente con \
listas, evaluando una funci\[OAcute]n apropiada o mediante una regla de \
sustituci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(lista2 = 1\/\(1 + lista1^3\)\)], "Input"],

Cell[TextData[{
  "Esto puede hacerse porque ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe trabajar con listas: podemos sumar un n\[UAcute]mero a una lista y \
podemos dividir un n\[UAcute]mero por una lista. Estas operaciones con listas \
se hacen siempre elemento a elemento."
}], "Text"],

Cell[BoxData[{
    \(func[x_] = 1\/\(1 + x\^3\); \nlista2 == Map[func, lista1]\), 
    \(lista2 == func[lista1]\ \)}], "Input"],

Cell[TextData[{
  "Muchas funciones pueden evaluarse directamente en listas. Esto es cierto \
casi para todas las funciones de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " y para much\[IAcute]simas de las que definimos nosotros. Aunque no hay \
una regla infalible para saber cu\[AAcute]ndo puede evaluarse directamente \
una funci\[OAcute]n en listas. Por eso aconsejo usar el comando \
Map[funcion,lista]."
}], "Text"],

Cell[BoxData[{
    \(funcioncilla[x_] := Log[x + \@\(1 + x\^2\)] /; x > 0\), 
    \(funcioncilla[x_] := Pi; \n
    funcioncilla[{\(-1\), 2, 3}] (*\ 
      no\ se\ eval\[UAcute]a\ en\ los\ elementos\ de\ la\ lista\ *) \), 
    \(Map[funcioncilla, {\(-1\), 2, 3}] (*\ ahora\ s\[IAcute]\ *) \)}], 
  "Input"],

Cell["Tambi\[EAcute]n podemos definir la lista2 como sigue.", "Text"],

Cell[BoxData[
    \(lista2 == \((lista1 /. x_?NumberQ \[Rule] 1\/\(1 + x\^3\))\)\)], "Input"],

Cell["Algunos hacen esto.", "Text"],

Cell[BoxData[
    \(lista2 == \((lista1 /. x_ \[Rule] 1\/\(1 + x\^3\))\)\)], "Input"],

Cell[TextData[{
  "Lo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " hace en esta regla de sustituci\[OAcute]n consiste en reemplazar el s\
\[IAcute]mblo x_ de la regla por lista1 y hacer la operaci\[OAcute]n \
indicada. Por tanto esta regla es equivalente a definir lista2 como lo \
hicimos la primera vez. Debes entender que el s\[IAcute]mbolo x_ es un modelo \
general del que no hemos especificado ninguna propiedad. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " busca a la izquierda de la regla y reemplaza x_ por el modelo m\[AAcute]s \
general que hay a la izquierda que, en este caso, es la lista1."
}], "Text"],

Cell[TextData[{
  StyleBox["c)",
    FontWeight->"Bold"],
  " Este apartado puede hacerse tambi\[EAcute]n de varias formas. La m\
\[AAcute]s sencilla (que no ha hecho nadie) es usar el comando Transpose[ ] \
que est\[AAcute] explicado en el primer cuaderno de pr\[AAcute]cticas. "
}], "Text"],

Cell[BoxData[
    \(lista3 = Transpose[{lista1, lista2}]\)], "Input"],

Cell["\<\
Lo que hemos hecho es convertir la matriz {lista1,lista2} de dos filas y 201 \
columnas en una matriz de 201 filas y dos columnas, que es justamente lo que \
se pide. Tambi\[EAcute]n puede hacerse seleccionando elementos en cada lista \
y emparejando los que ocupan igual lugar. Como sigue.\
\>", "Text"],

Cell[BoxData[
    \(lista3 == 
      Table[{lista1[\([k]\)], lista2[\([k]\)]}, {k, 1, Length[lista1]}]\)], 
  "Input"],

Cell[TextData[{
  StyleBox["d)",
    FontWeight->"Bold"],
  " Este apartado no deja lugar a muchas elecciones. La forma de evaluar una \
funci\[OAcute]n en los elementos de una lista est\[AAcute] claramente \
explicada en el primer cuaderno de pr\[AAcute]cticas, donde se pone \
precisamente como ejemplo la forma de evaluar una funci\[OAcute]n de dos \
variables en una lista de vectores de la forma {x,y}. "
}], "Text"],

Cell[BoxData[
    \(f[{x_, y_}] = \((x - y)\)/\((1 + x^2 + y^2)\); \n
    lista4 = Map[f, lista3]\)], "Input"],

Cell["\<\
Para hacer operaciones hay que poner par\[EAcute]ntesis donde sean \
necesarios. Aconsejo que us\[EAcute]is la paleta para escribir cocientes y as\
\[IAcute] no os equivocar\[EAcute]is.\
\>", "Text"],

Cell["\<\
Tambi\[EAcute]n se puede hacer lo mismo con una regla de sustituci\[OAcute]n.\
\
\>", "Text"],

Cell[BoxData[
    \(lista4 == 
      \((lista3 /. {x_, y_} \[Rule] \((x - y)\)/\((1 + x^2 + y^2)\))\)\)], 
  "Input"],

Cell[TextData[{
  "Observa que en este caso, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " busca el modelo {x_,y_} a la izquierda de la regla por lo que aplica la \
operaci\[OAcute]n indicada a cada uno de los elementos de lista3 porque \
responden a ese modelo. Aunque ser\[IAcute]a m\[AAcute]s seguro escribir \
{x_?NumberQ, y_?NumberQ}."
}], "Text"],

Cell["Hay otras formas de hacerlo pero son menos eficaces.", "Text"],

Cell[TextData[{
  StyleBox["e)",
    FontWeight->"Bold"],
  " En este apartado se pide usar el comando Select[ ]. Se ha explicado con \
detalle c\[OAcute]mo funciona dicho comando en la primera pr\[AAcute]ctica. \
Primero hay que definir un criterio de selecci\[OAcute]n y aplicarlo con \
Select[ ]."
}], "Text"],

Cell[BoxData[
    \(elige[x_] := \(-1\)\/7 < x < 1\/7; \nSelect[lista4, elige]\)], "Input"],

Cell["\<\
Aqu\[IAcute] los principales fallos son al definir el criterio de selecci\
\[OAcute]n.\
\>", "Text"],

Cell["f) Este \[UAcute]ltimo apartado es inmediato.", "Text"],

Cell[BoxData[
    \(Apply[Plus, %^2]\)], "Input"],

Cell["\<\
Todos y cada uno de los apartados anteriores est\[AAcute]n ejemplificados en \
el cuaderno de la primera pr\[AAcute]ctica. \
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsection"],

Cell["\<\
En este ejercicio debes hacer una animaci\[OAcute]n gr\[AAcute]fica. Para \
ello representa gr\[AAcute]ficamente las funciones sen(n x) - n cos(2 n x) en \
el intervalo [-Pi,Pi] para valores de n=1,2,3,4,5. Las gr\[AAcute]ficas deben \
tener color azul y grosor 0.007. Debes fijar el mismo rango para todas ellas. \
Sobre cada gr\[AAcute]fica debes representar los puntos (t, sen(n t) - n \
cos(2 n t)) para t variando desde -3 a 3 con incrementos de 1. Dichos puntos \
deben tener tama\[NTilde]o 0.02 y color rojo.\
\>", "Text"],

Cell[BoxData[
    \(\(Animate[
      Plot[Sin[n\ x] - n*Cos[2\ n\ x], {x, \(-Pi\), Pi}, 
        PlotStyle -> {Hue[ .65], Thickness[ .007]}, PlotRange -> {\(-6\), 6}, 
        Epilog -> 
          Table[{Hue[0], PointSize[ .02], 
              Point[{t, Sin[n\ t] - n*Cos[2\ n\ t]}]}, {t, \(-3\), 3, 1}]], {
        n, 1, 5, 1}]; \)\)], "Input"],

Cell["Eso es todo.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Observaciones sobre la evaluaci\[OAcute]n de los ejercicios", 
  "Subsection"],

Cell["\<\
Los disparates quitan puntos. Los fallos elementales como escribir funciones \
con par\[EAcute]ntesis, es decir f(x) en vez de f[x], o nombres de funciones \
equivocados o con min\[UAcute]sculas quitan muchos puntos. Al calificar tengo \
en cuenta que disponeis de ayuda: la propia del programa, los cuadernos de pr\
\[AAcute]cticas y vuestro propio trabajo. Por eso quien, a pesar de todo, \
comete disparates, considero que no ha estudiado nada y ni siquiera sabe \
buscar la informaci\[OAcute]n que necesita. Espero que hay\[AAcute]is \
comprobado que de nada sirve tener informaci\[OAcute]n y ayuda si antes no se \
ha aprendido a usarla correctamente.\
\>", "Text"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 33, 0, 56, "Subsection"],
Cell[1767, 53, 1418, 34, 246, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3222, 92, 38, 0, 56, "Subsection"],
Cell[3263, 94, 60, 1, 33, "Text"],
Cell[3326, 97, 64, 1, 60, "Input"],
Cell[3393, 100, 57, 0, 33, "Text"],
Cell[3453, 102, 137, 2, 60, "Input"],
Cell[3593, 106, 537, 8, 75, "Text"],
Cell[4133, 116, 168, 3, 60, "Input"],
Cell[4304, 121, 245, 6, 34, "Text"],
Cell[4552, 129, 61, 1, 73, "Input"],
Cell[4616, 132, 308, 7, 54, "Text"],
Cell[4927, 141, 127, 2, 116, "Input"],
Cell[5057, 145, 434, 9, 75, "Text"],
Cell[5494, 156, 305, 6, 129, "Input"],
Cell[5802, 164, 69, 0, 33, "Text"],
Cell[5874, 166, 93, 1, 73, "Input"],
Cell[5970, 169, 35, 0, 33, "Text"],
Cell[6008, 171, 85, 1, 73, "Input"],
Cell[6096, 174, 648, 13, 75, "Text"],
Cell[6747, 189, 292, 6, 55, "Text"],
Cell[7042, 197, 69, 1, 60, "Input"],
Cell[7114, 200, 314, 5, 54, "Text"],
Cell[7431, 207, 118, 3, 60, "Input"],
Cell[7552, 212, 421, 8, 55, "Text"],
Cell[7976, 222, 110, 2, 81, "Input"],
Cell[8089, 226, 209, 4, 33, "Text"],
Cell[8301, 232, 103, 3, 33, "Text"],
Cell[8407, 237, 117, 3, 60, "Input"],
Cell[8527, 242, 365, 8, 54, "Text"],
Cell[8895, 252, 68, 0, 33, "Text"],
Cell[8966, 254, 312, 7, 55, "Text"],
Cell[9281, 263, 91, 1, 95, "Input"],
Cell[9375, 266, 110, 3, 33, "Text"],
Cell[9488, 271, 61, 0, 33, "Text"],
Cell[9552, 273, 49, 1, 60, "Input"],
Cell[9604, 276, 147, 3, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9788, 284, 33, 0, 56, "Subsection"],
Cell[9824, 286, 539, 8, 75, "Text"],
Cell[10366, 296, 345, 7, 123, "Input"],
Cell[10714, 305, 28, 0, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10779, 310, 84, 1, 56, "Subsection"],
Cell[10866, 313, 680, 10, 96, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

